/*******************************************************************************
    Copyright (c) 1993-2020, NVIDIA CORPORATION. All rights reserved.

    Permission is hereby granted, free of charge, to any person obtaining a
    copy of this software and associated documentation files (the "Software"),
    to deal in the Software without restriction, including without limitation
    the rights to use, copy, modify, merge, publish, distribute, sublicense,
    and/or sell copies of the Software, and to permit persons to whom the
    Software is furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
    THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
    FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
    DEALINGS IN THE SOFTWARE.

*******************************************************************************/

#ifndef clc5b7_h_
#define clc5b7_h_

#ifdef __cplusplus
extern "C" {
#endif

#define NVC5B7_VIDEO_ENCODER                                                             (0x0000C5B7U)



#define NVC5B7_NOP                                                              (0x00000100U)
#define NVC5B7_NOP_PARAMETER                                                    31:0
#define NVC5B7_NOP_PARAMETER_HIGH_FIELD                                         31U
#define NVC5B7_NOP_PARAMETER_LOW_FIELD                                          0U
#define NVC5B7_SET_APPLICATION_ID                                               (0x00000200U)
#define NVC5B7_SET_APPLICATION_ID_ID                                            31:0
#define NVC5B7_SET_APPLICATION_ID_ID_HIGH_FIELD                                 31U
#define NVC5B7_SET_APPLICATION_ID_ID_LOW_FIELD                                  0U
#define NVC5B7_SET_APPLICATION_ID_ID_NVENC_H264                                 (0x00000001U)
#define NVC5B7_SET_APPLICATION_ID_ID_NVENC_VP8                                  (0x00000002U)
#define NVC5B7_SET_APPLICATION_ID_ID_NVENC_H265                                 (0x00000003U)
#define NVC5B7_SET_APPLICATION_ID_ID_NVENC_VP9                                  (0x00000004U)
#define NVC5B7_SET_APPLICATION_ID_ID_NVENC_RC                                   (0x00000005U)
#define NVC5B7_SET_APPLICATION_ID_ID_NVENC_OFS                                  (0x00000006U)
#define NVC5B7_SET_WATCHDOG_TIMER                                               (0x00000204U)
#define NVC5B7_SET_WATCHDOG_TIMER_TIMER                                         31:0
#define NVC5B7_SET_WATCHDOG_TIMER_TIMER_HIGH_FIELD                              31U
#define NVC5B7_SET_WATCHDOG_TIMER_TIMER_LOW_FIELD                               0U
#define NVC5B7_SEMAPHORE_A                                                      (0x00000240U)
#define NVC5B7_SEMAPHORE_A_UPPER                                                7:0
#define NVC5B7_SEMAPHORE_A_UPPER_HIGH_FIELD                                     7U
#define NVC5B7_SEMAPHORE_A_UPPER_LOW_FIELD                                      0U
#define NVC5B7_SEMAPHORE_B                                                      (0x00000244U)
#define NVC5B7_SEMAPHORE_B_LOWER                                                31:0
#define NVC5B7_SEMAPHORE_B_LOWER_HIGH_FIELD                                     31U
#define NVC5B7_SEMAPHORE_B_LOWER_LOW_FIELD                                      0U
#define NVC5B7_SEMAPHORE_C                                                      (0x00000248U)
#define NVC5B7_SEMAPHORE_C_PAYLOAD                                              31:0
#define NVC5B7_SEMAPHORE_C_PAYLOAD_HIGH_FIELD                                   31U
#define NVC5B7_SEMAPHORE_C_PAYLOAD_LOW_FIELD                                    0U
#define NVC5B7_CTX_SAVE_AREA                                                    (0x0000024CU)
#define NVC5B7_CTX_SAVE_AREA_OFFSET                                             27:0
#define NVC5B7_CTX_SAVE_AREA_OFFSET_HIGH_FIELD                                  27U
#define NVC5B7_CTX_SAVE_AREA_OFFSET_LOW_FIELD                                   0U
#define NVC5B7_CTX_SAVE_AREA_CTX_VALID                                          31:28
#define NVC5B7_CTX_SAVE_AREA_CTX_VALID_HIGH_FIELD                               31U
#define NVC5B7_CTX_SAVE_AREA_CTX_VALID_LOW_FIELD                                28U
#define NVC5B7_CTX_SWITCH                                                       (0x00000250U)
#define NVC5B7_CTX_SWITCH_RESTORE                                               0:0
#define NVC5B7_CTX_SWITCH_RESTORE_HIGH_FIELD                                    0U
#define NVC5B7_CTX_SWITCH_RESTORE_LOW_FIELD                                     0U
#define NVC5B7_CTX_SWITCH_RESTORE_FALSE                                         (0x00000000U)
#define NVC5B7_CTX_SWITCH_RESTORE_TRUE                                          (0x00000001U)
#define NVC5B7_CTX_SWITCH_RST_NOTIFY                                            1:1
#define NVC5B7_CTX_SWITCH_RST_NOTIFY_HIGH_FIELD                                 1U
#define NVC5B7_CTX_SWITCH_RST_NOTIFY_LOW_FIELD                                  1U
#define NVC5B7_CTX_SWITCH_RST_NOTIFY_FALSE                                      (0x00000000U)
#define NVC5B7_CTX_SWITCH_RST_NOTIFY_TRUE                                       (0x00000001U)
#define NVC5B7_CTX_SWITCH_RESERVED                                              7:2
#define NVC5B7_CTX_SWITCH_RESERVED_HIGH_FIELD                                   7U
#define NVC5B7_CTX_SWITCH_RESERVED_LOW_FIELD                                    2U
#define NVC5B7_CTX_SWITCH_ASID                                                  23:8
#define NVC5B7_CTX_SWITCH_ASID_HIGH_FIELD                                       23U
#define NVC5B7_CTX_SWITCH_ASID_LOW_FIELD                                        8U
#define NVC5B7_EXECUTE                                                          (0x00000300U)
#define NVC5B7_EXECUTE_NOTIFY                                                   0:0
#define NVC5B7_EXECUTE_NOTIFY_HIGH_FIELD                                        0U
#define NVC5B7_EXECUTE_NOTIFY_LOW_FIELD                                         0U
#define NVC5B7_EXECUTE_NOTIFY_DISABLE                                           (0x00000000U)
#define NVC5B7_EXECUTE_NOTIFY_ENABLE                                            (0x00000001U)
#define NVC5B7_EXECUTE_NOTIFY_ON                                                1:1
#define NVC5B7_EXECUTE_NOTIFY_ON_HIGH_FIELD                                     1U
#define NVC5B7_EXECUTE_NOTIFY_ON_LOW_FIELD                                      1U
#define NVC5B7_EXECUTE_NOTIFY_ON_END                                            (0x00000000U)
#define NVC5B7_EXECUTE_NOTIFY_ON_BEGIN                                          (0x00000001U)
#define NVC5B7_EXECUTE_AWAKEN                                                   8:8
#define NVC5B7_EXECUTE_AWAKEN_HIGH_FIELD                                        8U
#define NVC5B7_EXECUTE_AWAKEN_LOW_FIELD                                         8U
#define NVC5B7_EXECUTE_AWAKEN_DISABLE                                           (0x00000000U)
#define NVC5B7_EXECUTE_AWAKEN_ENABLE                                            (0x00000001U)
#define NVC5B7_SEMAPHORE_D                                                      (0x00000304U)
#define NVC5B7_SEMAPHORE_D_STRUCTURE_SIZE                                       0:0
#define NVC5B7_SEMAPHORE_D_STRUCTURE_SIZE_HIGH_FIELD                            0U
#define NVC5B7_SEMAPHORE_D_STRUCTURE_SIZE_LOW_FIELD                             0U
#define NVC5B7_SEMAPHORE_D_STRUCTURE_SIZE_ONE                                   (0x00000000U)
#define NVC5B7_SEMAPHORE_D_STRUCTURE_SIZE_FOUR                                  (0x00000001U)
#define NVC5B7_SEMAPHORE_D_AWAKEN_ENABLE                                        8:8
#define NVC5B7_SEMAPHORE_D_AWAKEN_ENABLE_HIGH_FIELD                             8U
#define NVC5B7_SEMAPHORE_D_AWAKEN_ENABLE_LOW_FIELD                              8U
#define NVC5B7_SEMAPHORE_D_AWAKEN_ENABLE_FALSE                                  (0x00000000U)
#define NVC5B7_SEMAPHORE_D_AWAKEN_ENABLE_TRUE                                   (0x00000001U)
#define NVC5B7_SEMAPHORE_D_OPERATION                                            17:16
#define NVC5B7_SEMAPHORE_D_OPERATION_HIGH_FIELD                                 17U
#define NVC5B7_SEMAPHORE_D_OPERATION_LOW_FIELD                                  16U
#define NVC5B7_SEMAPHORE_D_OPERATION_RELEASE                                    (0x00000000U)
#define NVC5B7_SEMAPHORE_D_OPERATION_RESERVED0                                  (0x00000001U)
#define NVC5B7_SEMAPHORE_D_OPERATION_RESERVED1                                  (0x00000002U)
#define NVC5B7_SEMAPHORE_D_OPERATION_TRAP                                       (0x00000003U)
#define NVC5B7_SEMAPHORE_D_FLUSH_DISABLE                                        21:21
#define NVC5B7_SEMAPHORE_D_FLUSH_DISABLE_HIGH_FIELD                             21U
#define NVC5B7_SEMAPHORE_D_FLUSH_DISABLE_LOW_FIELD                              21U
#define NVC5B7_SEMAPHORE_D_FLUSH_DISABLE_FALSE                                  (0x00000000U)
#define NVC5B7_SEMAPHORE_D_FLUSH_DISABLE_TRUE                                   (0x00000001U)
#define NVC5B7_SET_IN_REF_PIC0_LUMA                                             (0x00000400U)
#define NVC5B7_SET_IN_REF_PIC0_LUMA_OFFSET                                      31:0
#define NVC5B7_SET_IN_REF_PIC0_LUMA_OFFSET_HIGH_FIELD                           31U
#define NVC5B7_SET_IN_REF_PIC0_LUMA_OFFSET_LOW_FIELD                            0U
#define NVC5B7_SET_IN_REF_PIC1_LUMA                                             (0x00000404U)
#define NVC5B7_SET_IN_REF_PIC1_LUMA_OFFSET                                      31:0
#define NVC5B7_SET_IN_REF_PIC1_LUMA_OFFSET_HIGH_FIELD                           31U
#define NVC5B7_SET_IN_REF_PIC1_LUMA_OFFSET_LOW_FIELD                            0U
#define NVC5B7_SET_IN_REF_PIC2_LUMA                                             (0x00000408U)
#define NVC5B7_SET_IN_REF_PIC2_LUMA_OFFSET                                      31:0
#define NVC5B7_SET_IN_REF_PIC2_LUMA_OFFSET_HIGH_FIELD                           31U
#define NVC5B7_SET_IN_REF_PIC2_LUMA_OFFSET_LOW_FIELD                            0U
#define NVC5B7_SET_IN_REF_PIC3_LUMA                                             (0x0000040CU)
#define NVC5B7_SET_IN_REF_PIC3_LUMA_OFFSET                                      31:0
#define NVC5B7_SET_IN_REF_PIC3_LUMA_OFFSET_HIGH_FIELD                           31U
#define NVC5B7_SET_IN_REF_PIC3_LUMA_OFFSET_LOW_FIELD                            0U
#define NVC5B7_SET_IN_REF_PIC4_LUMA                                             (0x00000410U)
#define NVC5B7_SET_IN_REF_PIC4_LUMA_OFFSET                                      31:0
#define NVC5B7_SET_IN_REF_PIC4_LUMA_OFFSET_HIGH_FIELD                           31U
#define NVC5B7_SET_IN_REF_PIC4_LUMA_OFFSET_LOW_FIELD                            0U
#define NVC5B7_SET_IN_REF_PIC5_LUMA                                             (0x00000414U)
#define NVC5B7_SET_IN_REF_PIC5_LUMA_OFFSET                                      31:0
#define NVC5B7_SET_IN_REF_PIC5_LUMA_OFFSET_HIGH_FIELD                           31U
#define NVC5B7_SET_IN_REF_PIC5_LUMA_OFFSET_LOW_FIELD                            0U
#define NVC5B7_SET_IN_REF_PIC6_LUMA                                             (0x00000418U)
#define NVC5B7_SET_IN_REF_PIC6_LUMA_OFFSET                                      31:0
#define NVC5B7_SET_IN_REF_PIC6_LUMA_OFFSET_HIGH_FIELD                           31U
#define NVC5B7_SET_IN_REF_PIC6_LUMA_OFFSET_LOW_FIELD                            0U
#define NVC5B7_SET_IN_REF_PIC7_LUMA                                             (0x0000041CU)
#define NVC5B7_SET_IN_REF_PIC7_LUMA_OFFSET                                      31:0
#define NVC5B7_SET_IN_REF_PIC7_LUMA_OFFSET_HIGH_FIELD                           31U
#define NVC5B7_SET_IN_REF_PIC7_LUMA_OFFSET_LOW_FIELD                            0U
#define NVC5B7_SET_IN_REF_PIC8_LUMA                                             (0x00000420U)
#define NVC5B7_SET_IN_REF_PIC8_LUMA_OFFSET                                      31:0
#define NVC5B7_SET_IN_REF_PIC8_LUMA_OFFSET_HIGH_FIELD                           31U
#define NVC5B7_SET_IN_REF_PIC8_LUMA_OFFSET_LOW_FIELD                            0U
#define NVC5B7_SET_IN_REF_PIC9_LUMA                                             (0x00000424U)
#define NVC5B7_SET_IN_REF_PIC9_LUMA_OFFSET                                      31:0
#define NVC5B7_SET_IN_REF_PIC9_LUMA_OFFSET_HIGH_FIELD                           31U
#define NVC5B7_SET_IN_REF_PIC9_LUMA_OFFSET_LOW_FIELD                            0U
#define NVC5B7_SET_IN_REF_PIC10_LUMA                                            (0x00000428U)
#define NVC5B7_SET_IN_REF_PIC10_LUMA_OFFSET                                     31:0
#define NVC5B7_SET_IN_REF_PIC10_LUMA_OFFSET_HIGH_FIELD                          31U
#define NVC5B7_SET_IN_REF_PIC10_LUMA_OFFSET_LOW_FIELD                           0U
#define NVC5B7_SET_IN_REF_PIC11_LUMA                                            (0x0000042CU)
#define NVC5B7_SET_IN_REF_PIC11_LUMA_OFFSET                                     31:0
#define NVC5B7_SET_IN_REF_PIC11_LUMA_OFFSET_HIGH_FIELD                          31U
#define NVC5B7_SET_IN_REF_PIC11_LUMA_OFFSET_LOW_FIELD                           0U
#define NVC5B7_SET_IN_REF_PIC12_LUMA                                            (0x00000430U)
#define NVC5B7_SET_IN_REF_PIC12_LUMA_OFFSET                                     31:0
#define NVC5B7_SET_IN_REF_PIC12_LUMA_OFFSET_HIGH_FIELD                          31U
#define NVC5B7_SET_IN_REF_PIC12_LUMA_OFFSET_LOW_FIELD                           0U
#define NVC5B7_SET_IN_REF_PIC13_LUMA                                            (0x00000434U)
#define NVC5B7_SET_IN_REF_PIC13_LUMA_OFFSET                                     31:0
#define NVC5B7_SET_IN_REF_PIC13_LUMA_OFFSET_HIGH_FIELD                          31U
#define NVC5B7_SET_IN_REF_PIC13_LUMA_OFFSET_LOW_FIELD                           0U
#define NVC5B7_SET_IN_REF_PIC14_LUMA                                            (0x00000438U)
#define NVC5B7_SET_IN_REF_PIC14_LUMA_OFFSET                                     31:0
#define NVC5B7_SET_IN_REF_PIC14_LUMA_OFFSET_HIGH_FIELD                          31U
#define NVC5B7_SET_IN_REF_PIC14_LUMA_OFFSET_LOW_FIELD                           0U
#define NVC5B7_SET_IN_REF_PIC15_LUMA                                            (0x0000043CU)
#define NVC5B7_SET_IN_REF_PIC15_LUMA_OFFSET                                     31:0
#define NVC5B7_SET_IN_REF_PIC15_LUMA_OFFSET_HIGH_FIELD                          31U
#define NVC5B7_SET_IN_REF_PIC15_LUMA_OFFSET_LOW_FIELD                           0U
#define NVC5B7_SET_IN_REF_PIC0_CHROMA                                           (0x00000440U)
#define NVC5B7_SET_IN_REF_PIC0_CHROMA_OFFSET                                    31:0
#define NVC5B7_SET_IN_REF_PIC0_CHROMA_OFFSET_HIGH_FIELD                         31U
#define NVC5B7_SET_IN_REF_PIC0_CHROMA_OFFSET_LOW_FIELD                          0U
#define NVC5B7_SET_IN_REF_PIC1_CHROMA                                           (0x00000444U)
#define NVC5B7_SET_IN_REF_PIC1_CHROMA_OFFSET                                    31:0
#define NVC5B7_SET_IN_REF_PIC1_CHROMA_OFFSET_HIGH_FIELD                         31U
#define NVC5B7_SET_IN_REF_PIC1_CHROMA_OFFSET_LOW_FIELD                          0U
#define NVC5B7_SET_IN_REF_PIC2_CHROMA                                           (0x00000448U)
#define NVC5B7_SET_IN_REF_PIC2_CHROMA_OFFSET                                    31:0
#define NVC5B7_SET_IN_REF_PIC2_CHROMA_OFFSET_HIGH_FIELD                         31U
#define NVC5B7_SET_IN_REF_PIC2_CHROMA_OFFSET_LOW_FIELD                          0U
#define NVC5B7_SET_IN_REF_PIC3_CHROMA                                           (0x0000044CU)
#define NVC5B7_SET_IN_REF_PIC3_CHROMA_OFFSET                                    31:0
#define NVC5B7_SET_IN_REF_PIC3_CHROMA_OFFSET_HIGH_FIELD                         31U
#define NVC5B7_SET_IN_REF_PIC3_CHROMA_OFFSET_LOW_FIELD                          0U
#define NVC5B7_SET_IN_REF_PIC4_CHROMA                                           (0x00000450U)
#define NVC5B7_SET_IN_REF_PIC4_CHROMA_OFFSET                                    31:0
#define NVC5B7_SET_IN_REF_PIC4_CHROMA_OFFSET_HIGH_FIELD                         31U
#define NVC5B7_SET_IN_REF_PIC4_CHROMA_OFFSET_LOW_FIELD                          0U
#define NVC5B7_SET_IN_REF_PIC5_CHROMA                                           (0x00000454U)
#define NVC5B7_SET_IN_REF_PIC5_CHROMA_OFFSET                                    31:0
#define NVC5B7_SET_IN_REF_PIC5_CHROMA_OFFSET_HIGH_FIELD                         31U
#define NVC5B7_SET_IN_REF_PIC5_CHROMA_OFFSET_LOW_FIELD                          0U
#define NVC5B7_SET_IN_REF_PIC6_CHROMA                                           (0x00000458U)
#define NVC5B7_SET_IN_REF_PIC6_CHROMA_OFFSET                                    31:0
#define NVC5B7_SET_IN_REF_PIC6_CHROMA_OFFSET_HIGH_FIELD                         31U
#define NVC5B7_SET_IN_REF_PIC6_CHROMA_OFFSET_LOW_FIELD                          0U
#define NVC5B7_SET_IN_REF_PIC7_CHROMA                                           (0x0000045CU)
#define NVC5B7_SET_IN_REF_PIC7_CHROMA_OFFSET                                    31:0
#define NVC5B7_SET_IN_REF_PIC7_CHROMA_OFFSET_HIGH_FIELD                         31U
#define NVC5B7_SET_IN_REF_PIC7_CHROMA_OFFSET_LOW_FIELD                          0U
#define NVC5B7_SET_IN_REF_PIC8_CHROMA                                           (0x00000460U)
#define NVC5B7_SET_IN_REF_PIC8_CHROMA_OFFSET                                    31:0
#define NVC5B7_SET_IN_REF_PIC8_CHROMA_OFFSET_HIGH_FIELD                         31U
#define NVC5B7_SET_IN_REF_PIC8_CHROMA_OFFSET_LOW_FIELD                          0U
#define NVC5B7_SET_IN_REF_PIC9_CHROMA                                           (0x00000464U)
#define NVC5B7_SET_IN_REF_PIC9_CHROMA_OFFSET                                    31:0
#define NVC5B7_SET_IN_REF_PIC9_CHROMA_OFFSET_HIGH_FIELD                         31U
#define NVC5B7_SET_IN_REF_PIC9_CHROMA_OFFSET_LOW_FIELD                          0U
#define NVC5B7_SET_IN_REF_PIC10_CHROMA                                          (0x00000468U)
#define NVC5B7_SET_IN_REF_PIC10_CHROMA_OFFSET                                   31:0
#define NVC5B7_SET_IN_REF_PIC10_CHROMA_OFFSET_HIGH_FIELD                        31U
#define NVC5B7_SET_IN_REF_PIC10_CHROMA_OFFSET_LOW_FIELD                         0U
#define NVC5B7_SET_IN_REF_PIC11_CHROMA                                          (0x0000046CU)
#define NVC5B7_SET_IN_REF_PIC11_CHROMA_OFFSET                                   31:0
#define NVC5B7_SET_IN_REF_PIC11_CHROMA_OFFSET_HIGH_FIELD                        31U
#define NVC5B7_SET_IN_REF_PIC11_CHROMA_OFFSET_LOW_FIELD                         0U
#define NVC5B7_SET_IN_REF_PIC12_CHROMA                                          (0x00000470U)
#define NVC5B7_SET_IN_REF_PIC12_CHROMA_OFFSET                                   31:0
#define NVC5B7_SET_IN_REF_PIC12_CHROMA_OFFSET_HIGH_FIELD                        31U
#define NVC5B7_SET_IN_REF_PIC12_CHROMA_OFFSET_LOW_FIELD                         0U
#define NVC5B7_SET_IN_REF_PIC13_CHROMA                                          (0x00000474U)
#define NVC5B7_SET_IN_REF_PIC13_CHROMA_OFFSET                                   31:0
#define NVC5B7_SET_IN_REF_PIC13_CHROMA_OFFSET_HIGH_FIELD                        31U
#define NVC5B7_SET_IN_REF_PIC13_CHROMA_OFFSET_LOW_FIELD                         0U
#define NVC5B7_SET_IN_REF_PIC14_CHROMA                                          (0x00000478U)
#define NVC5B7_SET_IN_REF_PIC14_CHROMA_OFFSET                                   31:0
#define NVC5B7_SET_IN_REF_PIC14_CHROMA_OFFSET_HIGH_FIELD                        31U
#define NVC5B7_SET_IN_REF_PIC14_CHROMA_OFFSET_LOW_FIELD                         0U
#define NVC5B7_SET_IN_REF_PIC15_CHROMA                                          (0x0000047CU)
#define NVC5B7_SET_IN_REF_PIC15_CHROMA_OFFSET                                   31:0
#define NVC5B7_SET_IN_REF_PIC15_CHROMA_OFFSET_HIGH_FIELD                        31U
#define NVC5B7_SET_IN_REF_PIC15_CHROMA_OFFSET_LOW_FIELD                         0U
#define NVC5B7_SET_IN_REF_PIC_LAST_LUMA                                         (0x00000500U)
#define NVC5B7_SET_IN_REF_PIC_LAST_LUMA_OFFSET                                  31:0
#define NVC5B7_SET_IN_REF_PIC_LAST_LUMA_OFFSET_HIGH_FIELD                       31U
#define NVC5B7_SET_IN_REF_PIC_LAST_LUMA_OFFSET_LOW_FIELD                        0U
#define NVC5B7_SET_IN_REF_PIC_GOLDEN_LUMA                                       (0x00000504U)
#define NVC5B7_SET_IN_REF_PIC_GOLDEN_LUMA_OFFSET                                31:0
#define NVC5B7_SET_IN_REF_PIC_GOLDEN_LUMA_OFFSET_HIGH_FIELD                     31U
#define NVC5B7_SET_IN_REF_PIC_GOLDEN_LUMA_OFFSET_LOW_FIELD                      0U
#define NVC5B7_SET_IN_REF_PIC_ALTREF_LUMA                                       (0x00000508U)
#define NVC5B7_SET_IN_REF_PIC_ALTREF_LUMA_OFFSET                                31:0
#define NVC5B7_SET_IN_REF_PIC_ALTREF_LUMA_OFFSET_HIGH_FIELD                     31U
#define NVC5B7_SET_IN_REF_PIC_ALTREF_LUMA_OFFSET_LOW_FIELD                      0U
#define NVC5B7_SET_UCODE_STATE                                                  (0x0000050CU)
#define NVC5B7_SET_UCODE_STATE_OFFSET                                           31:0
#define NVC5B7_SET_UCODE_STATE_OFFSET_HIGH_FIELD                                31U
#define NVC5B7_SET_UCODE_STATE_OFFSET_LOW_FIELD                                 0U
#define NVC5B7_SET_IO_VP8_ENC_STATUS                                            (0x00000510U)
#define NVC5B7_SET_IO_VP8_ENC_STATUS_OFFSET                                     31:0
#define NVC5B7_SET_IO_VP8_ENC_STATUS_OFFSET_HIGH_FIELD                          31U
#define NVC5B7_SET_IO_VP8_ENC_STATUS_OFFSET_LOW_FIELD                           0U
#define NVC5B7_SET_OUT_BITSTREAM_RES                                            (0x00000514U)
#define NVC5B7_SET_OUT_BITSTREAM_RES_OFFSET                                     31:0
#define NVC5B7_SET_OUT_BITSTREAM_RES_OFFSET_HIGH_FIELD                          31U
#define NVC5B7_SET_OUT_BITSTREAM_RES_OFFSET_LOW_FIELD                           0U
#define NVC5B7_SET_IN_REF_PIC_LAST_CHROMA                                       (0x00000518U)
#define NVC5B7_SET_IN_REF_PIC_LAST_CHROMA_OFFSET                                31:0
#define NVC5B7_SET_IN_REF_PIC_LAST_CHROMA_OFFSET_HIGH_FIELD                     31U
#define NVC5B7_SET_IN_REF_PIC_LAST_CHROMA_OFFSET_LOW_FIELD                      0U
#define NVC5B7_SET_IN_REF_PIC_GOLDEN_CHROMA                                     (0x0000051CU)
#define NVC5B7_SET_IN_REF_PIC_GOLDEN_CHROMA_OFFSET                              31:0
#define NVC5B7_SET_IN_REF_PIC_GOLDEN_CHROMA_OFFSET_HIGH_FIELD                   31U
#define NVC5B7_SET_IN_REF_PIC_GOLDEN_CHROMA_OFFSET_LOW_FIELD                    0U
#define NVC5B7_SET_IN_REF_PIC_ALTREF_CHROMA                                     (0x00000520U)
#define NVC5B7_SET_IN_REF_PIC_ALTREF_CHROMA_OFFSET                              31:0
#define NVC5B7_SET_IN_REF_PIC_ALTREF_CHROMA_OFFSET_HIGH_FIELD                   31U
#define NVC5B7_SET_IN_REF_PIC_ALTREF_CHROMA_OFFSET_LOW_FIELD                    0U
#define NVC5B7_SET_OUT_VP9_COUNTER_DATA                                         (0x00000524U)
#define NVC5B7_SET_OUT_VP9_COUNTER_DATA_OFFSET                                  31:0
#define NVC5B7_SET_OUT_VP9_COUNTER_DATA_OFFSET_HIGH_FIELD                       31U
#define NVC5B7_SET_OUT_VP9_COUNTER_DATA_OFFSET_LOW_FIELD                        0U
#define NVC5B7_SET_IN_VP9_PROBABILITY_DATA                                      (0x00000528U)
#define NVC5B7_SET_IN_VP9_PROBABILITY_DATA_OFFSET                               31:0
#define NVC5B7_SET_IN_VP9_PROBABILITY_DATA_OFFSET_HIGH_FIELD                    31U
#define NVC5B7_SET_IN_VP9_PROBABILITY_DATA_OFFSET_LOW_FIELD                     0U
#define NVC5B7_SET_IN_VP9_CUR_TEMPORAL_DATA                                     (0x0000052CU)
#define NVC5B7_SET_IN_VP9_CUR_TEMPORAL_DATA_OFFSET                              31:0
#define NVC5B7_SET_IN_VP9_CUR_TEMPORAL_DATA_OFFSET_HIGH_FIELD                   31U
#define NVC5B7_SET_IN_VP9_CUR_TEMPORAL_DATA_OFFSET_LOW_FIELD                    0U
#define NVC5B7_SET_IN_VP9_REF_TEMPORAL_DATA                                     (0x00000530U)
#define NVC5B7_SET_IN_VP9_REF_TEMPORAL_DATA_OFFSET                              31:0
#define NVC5B7_SET_IN_VP9_REF_TEMPORAL_DATA_OFFSET_HIGH_FIELD                   31U
#define NVC5B7_SET_IN_VP9_REF_TEMPORAL_DATA_OFFSET_LOW_FIELD                    0U
#define NVC5B7_SET_IN_VP9_COMBINEDLINE_BUF                                      (0x00000534U)
#define NVC5B7_SET_IN_VP9_COMBINEDLINE_BUF_OFFSET                               31:0
#define NVC5B7_SET_IN_VP9_COMBINEDLINE_BUF_OFFSET_HIGH_FIELD                    31U
#define NVC5B7_SET_IN_VP9_COMBINEDLINE_BUF_OFFSET_LOW_FIELD                     0U
#define NVC5B7_SET_IN_VP9_FILTERLINE_BUF                                        (0x00000538U)
#define NVC5B7_SET_IN_VP9_FILTERLINE_BUF_OFFSET                                 31:0
#define NVC5B7_SET_IN_VP9_FILTERLINE_BUF_OFFSET_HIGH_FIELD                      31U
#define NVC5B7_SET_IN_VP9_FILTERLINE_BUF_OFFSET_LOW_FIELD                       0U
#define NVC5B7_SET_IN_VP9_FILTERCOLLINE_BUF                                     (0x0000053CU)
#define NVC5B7_SET_IN_VP9_FILTERCOLLINE_BUF_OFFSET                              31:0
#define NVC5B7_SET_IN_VP9_FILTERCOLLINE_BUF_OFFSET_HIGH_FIELD                   31U
#define NVC5B7_SET_IN_VP9_FILTERCOLLINE_BUF_OFFSET_LOW_FIELD                    0U
#define NVC5B7_SET_IN_VP9_MOCOMP_PIC_LUMA                                       (0x00000544U)
#define NVC5B7_SET_IN_VP9_MOCOMP_PIC_LUMA_OFFSET                                31:0
#define NVC5B7_SET_IN_VP9_MOCOMP_PIC_LUMA_OFFSET_HIGH_FIELD                     31U
#define NVC5B7_SET_IN_VP9_MOCOMP_PIC_LUMA_OFFSET_LOW_FIELD                      0U
#define NVC5B7_SET_IN_VP9_MOCOMP_PIC_CHROMA                                     (0x00000548U)
#define NVC5B7_SET_IN_VP9_MOCOMP_PIC_CHROMA_OFFSET                              31:0
#define NVC5B7_SET_IN_VP9_MOCOMP_PIC_CHROMA_OFFSET_HIGH_FIELD                   31U
#define NVC5B7_SET_IN_VP9_MOCOMP_PIC_CHROMA_OFFSET_LOW_FIELD                    0U
#define NVC5B7_SET_CONTROL_PARAMS                                               (0x00000700U)
#define NVC5B7_SET_CONTROL_PARAMS_CODEC_TYPE                                    3:0
#define NVC5B7_SET_CONTROL_PARAMS_CODEC_TYPE_HIGH_FIELD                         3U
#define NVC5B7_SET_CONTROL_PARAMS_CODEC_TYPE_LOW_FIELD                          0U
#define NVC5B7_SET_CONTROL_PARAMS_CODEC_TYPE_H264                               (0x00000003U)
#define NVC5B7_SET_CONTROL_PARAMS_FORCE_OUT_PIC                                 8:8
#define NVC5B7_SET_CONTROL_PARAMS_FORCE_OUT_PIC_HIGH_FIELD                      8U
#define NVC5B7_SET_CONTROL_PARAMS_FORCE_OUT_PIC_LOW_FIELD                       8U
#define NVC5B7_SET_CONTROL_PARAMS_FORCE_OUT_COL                                 9:9
#define NVC5B7_SET_CONTROL_PARAMS_FORCE_OUT_COL_HIGH_FIELD                      9U
#define NVC5B7_SET_CONTROL_PARAMS_FORCE_OUT_COL_LOW_FIELD                       9U
#define NVC5B7_SET_CONTROL_PARAMS_MEONLY                                        10:10
#define NVC5B7_SET_CONTROL_PARAMS_MEONLY_HIGH_FIELD                             10U
#define NVC5B7_SET_CONTROL_PARAMS_MEONLY_LOW_FIELD                              10U
#define NVC5B7_SET_CONTROL_PARAMS_SLICE_STAT_ON                                 11:11
#define NVC5B7_SET_CONTROL_PARAMS_SLICE_STAT_ON_HIGH_FIELD                      11U
#define NVC5B7_SET_CONTROL_PARAMS_SLICE_STAT_ON_LOW_FIELD                       11U
#define NVC5B7_SET_CONTROL_PARAMS_GPTIMER_ON                                    12:12
#define NVC5B7_SET_CONTROL_PARAMS_GPTIMER_ON_HIGH_FIELD                         12U
#define NVC5B7_SET_CONTROL_PARAMS_GPTIMER_ON_LOW_FIELD                          12U
#define NVC5B7_SET_CONTROL_PARAMS_STOP_PROB_UPDATE                              13:13
#define NVC5B7_SET_CONTROL_PARAMS_STOP_PROB_UPDATE_HIGH_FIELD                   13U
#define NVC5B7_SET_CONTROL_PARAMS_STOP_PROB_UPDATE_LOW_FIELD                    13U
#define NVC5B7_SET_CONTROL_PARAMS_MPEC_STAT_ON                                  15:15
#define NVC5B7_SET_CONTROL_PARAMS_MPEC_STAT_ON_HIGH_FIELD                       15U
#define NVC5B7_SET_CONTROL_PARAMS_MPEC_STAT_ON_LOW_FIELD                        15U
#define NVC5B7_SET_CONTROL_PARAMS_SUBFRAME_MODE                                 18:17
#define NVC5B7_SET_CONTROL_PARAMS_SUBFRAME_MODE_HIGH_FIELD                      18U
#define NVC5B7_SET_CONTROL_PARAMS_SUBFRAME_MODE_LOW_FIELD                       17U
#define NVC5B7_SET_CONTROL_PARAMS_SUBFRAME_MODE_NONE                            (0x00000000U)
#define NVC5B7_SET_CONTROL_PARAMS_SUBFRAME_MODE_SLICE_FLUSH                     (0x00000001U)
#define NVC5B7_SET_CONTROL_PARAMS_SUBFRAME_MODE_SLICE_OFFSETS_WITHOUT_FLUSH     (0x00000002U)
#define NVC5B7_SET_CONTROL_PARAMS_SUBFRAME_MODE_SLICE_OFFSETS_WITH_FLUSH        (0x00000003U)
#define NVC5B7_SET_CONTROL_PARAMS_RCSTAT_WRITE                                  19:19
#define NVC5B7_SET_CONTROL_PARAMS_RCSTAT_WRITE_HIGH_FIELD                       19U
#define NVC5B7_SET_CONTROL_PARAMS_RCSTAT_WRITE_LOW_FIELD                        19U
#define NVC5B7_SET_CONTROL_PARAMS_RCSTAT_READ                                   20:20
#define NVC5B7_SET_CONTROL_PARAMS_RCSTAT_READ_HIGH_FIELD                        20U
#define NVC5B7_SET_CONTROL_PARAMS_RCSTAT_READ_LOW_FIELD                         20U
#define NVC5B7_SET_CONTROL_PARAMS_RCMODE                                        31:24
#define NVC5B7_SET_CONTROL_PARAMS_RCMODE_HIGH_FIELD                             31U
#define NVC5B7_SET_CONTROL_PARAMS_RCMODE_LOW_FIELD                              24U
#define NVC5B7_SET_CONTROL_PARAMS_RCMODE_CONSTQP                                (0x00000000U)
#define NVC5B7_SET_PICTURE_INDEX                                                (0x00000704U)
#define NVC5B7_SET_PICTURE_INDEX_INDEX                                          31:0
#define NVC5B7_SET_PICTURE_INDEX_INDEX_HIGH_FIELD                               31U
#define NVC5B7_SET_PICTURE_INDEX_INDEX_LOW_FIELD                                0U
#define NVC5B7_SET_IN_RCDATA                                                    (0x0000070CU)
#define NVC5B7_SET_IN_RCDATA_OFFSET                                             31:0
#define NVC5B7_SET_IN_RCDATA_OFFSET_HIGH_FIELD                                  31U
#define NVC5B7_SET_IN_RCDATA_OFFSET_LOW_FIELD                                   0U
#define NVC5B7_SET_IN_DRV_PIC_SETUP                                             (0x00000710U)
#define NVC5B7_SET_IN_DRV_PIC_SETUP_OFFSET                                      31:0
#define NVC5B7_SET_IN_DRV_PIC_SETUP_OFFSET_HIGH_FIELD                           31U
#define NVC5B7_SET_IN_DRV_PIC_SETUP_OFFSET_LOW_FIELD                            0U
#define NVC5B7_SET_IN_CEAHINTS_DATA                                             (0x00000714U)
#define NVC5B7_SET_IN_CEAHINTS_DATA_OFFSET                                      31:0
#define NVC5B7_SET_IN_CEAHINTS_DATA_OFFSET_HIGH_FIELD                           31U
#define NVC5B7_SET_IN_CEAHINTS_DATA_OFFSET_LOW_FIELD                            0U
#define NVC5B7_SET_OUT_ENC_STATUS                                               (0x00000718U)
#define NVC5B7_SET_OUT_ENC_STATUS_OFFSET                                        31:0
#define NVC5B7_SET_OUT_ENC_STATUS_OFFSET_HIGH_FIELD                             31U
#define NVC5B7_SET_OUT_ENC_STATUS_OFFSET_LOW_FIELD                              0U
#define NVC5B7_SET_OUT_BITSTREAM                                                (0x0000071CU)
#define NVC5B7_SET_OUT_BITSTREAM_OFFSET                                         31:0
#define NVC5B7_SET_OUT_BITSTREAM_OFFSET_HIGH_FIELD                              31U
#define NVC5B7_SET_OUT_BITSTREAM_OFFSET_LOW_FIELD                               0U
#define NVC5B7_SET_IOHISTORY                                                    (0x00000720U)
#define NVC5B7_SET_IOHISTORY_OFFSET                                             31:0
#define NVC5B7_SET_IOHISTORY_OFFSET_HIGH_FIELD                                  31U
#define NVC5B7_SET_IOHISTORY_OFFSET_LOW_FIELD                                   0U
#define NVC5B7_SET_IO_RC_PROCESS                                                (0x00000724U)
#define NVC5B7_SET_IO_RC_PROCESS_OFFSET                                         31:0
#define NVC5B7_SET_IO_RC_PROCESS_OFFSET_HIGH_FIELD                              31U
#define NVC5B7_SET_IO_RC_PROCESS_OFFSET_LOW_FIELD                               0U
#define NVC5B7_SET_IN_COLOC_DATA                                                (0x00000728U)
#define NVC5B7_SET_IN_COLOC_DATA_OFFSET                                         31:0
#define NVC5B7_SET_IN_COLOC_DATA_OFFSET_HIGH_FIELD                              31U
#define NVC5B7_SET_IN_COLOC_DATA_OFFSET_LOW_FIELD                               0U
#define NVC5B7_SET_OUT_COLOC_DATA                                               (0x0000072CU)
#define NVC5B7_SET_OUT_COLOC_DATA_OFFSET                                        31:0
#define NVC5B7_SET_OUT_COLOC_DATA_OFFSET_HIGH_FIELD                             31U
#define NVC5B7_SET_OUT_COLOC_DATA_OFFSET_LOW_FIELD                              0U
#define NVC5B7_SET_OUT_REF_PIC_LUMA                                             (0x00000730U)
#define NVC5B7_SET_OUT_REF_PIC_LUMA_OFFSET                                      31:0
#define NVC5B7_SET_OUT_REF_PIC_LUMA_OFFSET_HIGH_FIELD                           31U
#define NVC5B7_SET_OUT_REF_PIC_LUMA_OFFSET_LOW_FIELD                            0U
#define NVC5B7_SET_IN_CUR_PIC                                                   (0x00000734U)
#define NVC5B7_SET_IN_CUR_PIC_OFFSET                                            31:0
#define NVC5B7_SET_IN_CUR_PIC_OFFSET_HIGH_FIELD                                 31U
#define NVC5B7_SET_IN_CUR_PIC_OFFSET_LOW_FIELD                                  0U
#define NVC5B7_SET_IN_MEPRED_DATA                                               (0x00000738U)
#define NVC5B7_SET_IN_MEPRED_DATA_OFFSET                                        31:0
#define NVC5B7_SET_IN_MEPRED_DATA_OFFSET_HIGH_FIELD                             31U
#define NVC5B7_SET_IN_MEPRED_DATA_OFFSET_LOW_FIELD                              0U
#define NVC5B7_SET_OUT_MEPRED_DATA                                              (0x0000073CU)
#define NVC5B7_SET_OUT_MEPRED_DATA_OFFSET                                       31:0
#define NVC5B7_SET_OUT_MEPRED_DATA_OFFSET_HIGH_FIELD                            31U
#define NVC5B7_SET_OUT_MEPRED_DATA_OFFSET_LOW_FIELD                             0U
#define NVC5B7_SET_IN_CUR_PIC_CHROMA_U                                          (0x00000740U)
#define NVC5B7_SET_IN_CUR_PIC_CHROMA_U_OFFSET                                   31:0
#define NVC5B7_SET_IN_CUR_PIC_CHROMA_U_OFFSET_HIGH_FIELD                        31U
#define NVC5B7_SET_IN_CUR_PIC_CHROMA_U_OFFSET_LOW_FIELD                         0U
#define NVC5B7_SET_IN_CUR_PIC_CHROMA_V                                          (0x00000744U)
#define NVC5B7_SET_IN_CUR_PIC_CHROMA_V_OFFSET                                   31:0
#define NVC5B7_SET_IN_CUR_PIC_CHROMA_V_OFFSET_HIGH_FIELD                        31U
#define NVC5B7_SET_IN_CUR_PIC_CHROMA_V_OFFSET_LOW_FIELD                         0U
#define NVC5B7_SET_IN_QP_MAP                                                    (0x00000748U)
#define NVC5B7_SET_IN_QP_MAP_OFFSET                                             31:0
#define NVC5B7_SET_IN_QP_MAP_OFFSET_HIGH_FIELD                                  31U
#define NVC5B7_SET_IN_QP_MAP_OFFSET_LOW_FIELD                                   0U
#define NVC5B7_SET_OUT_REF_PIC_CHROMA                                           (0x0000074CU)
#define NVC5B7_SET_OUT_REF_PIC_CHROMA_OFFSET                                    31:0
#define NVC5B7_SET_OUT_REF_PIC_CHROMA_OFFSET_HIGH_FIELD                         31U
#define NVC5B7_SET_OUT_REF_PIC_CHROMA_OFFSET_LOW_FIELD                          0U
#define NVC5B7_SET_IN_PARTITION_BUF                                             (0x00000750U)
#define NVC5B7_SET_IN_PARTITION_BUF_OFFSET                                      31:0
#define NVC5B7_SET_IN_PARTITION_BUF_OFFSET_HIGH_FIELD                           31U
#define NVC5B7_SET_IN_PARTITION_BUF_OFFSET_LOW_FIELD                            0U
#define NVC5B7_SET_IN_CUR_PIC1_TASK_STATUS                                      (0x00000758U)
#define NVC5B7_SET_IN_CUR_PIC1_TASK_STATUS_OFFSET                               31:0
#define NVC5B7_SET_IN_CUR_PIC1_TASK_STATUS_OFFSET_HIGH_FIELD                    31U
#define NVC5B7_SET_IN_CUR_PIC1_TASK_STATUS_OFFSET_LOW_FIELD                     0U
#define NVC5B7_SET_IN_CUR_PIC2_TASK_STATUS                                      (0x0000075CU)
#define NVC5B7_SET_IN_CUR_PIC2_TASK_STATUS_OFFSET                               31:0
#define NVC5B7_SET_IN_CUR_PIC2_TASK_STATUS_OFFSET_HIGH_FIELD                    31U
#define NVC5B7_SET_IN_CUR_PIC2_TASK_STATUS_OFFSET_LOW_FIELD                     0U
#define NVC5B7_SET_OUT_TASK_STATUS                                              (0x00000760U)
#define NVC5B7_SET_OUT_TASK_STATUS_OFFSET                                       31:0
#define NVC5B7_SET_OUT_TASK_STATUS_OFFSET_HIGH_FIELD                            31U
#define NVC5B7_SET_OUT_TASK_STATUS_OFFSET_LOW_FIELD                             0U
#define NVC5B7_SET_IN_MV_HINTS_TASK_STATUS                                      (0x00000764U)
#define NVC5B7_SET_IN_MV_HINTS_TASK_STATUS_OFFSET                               31:0
#define NVC5B7_SET_IN_MV_HINTS_TASK_STATUS_OFFSET_HIGH_FIELD                    31U
#define NVC5B7_SET_IN_MV_HINTS_TASK_STATUS_OFFSET_LOW_FIELD                     0U

#define NVC5B7_ERROR_NONE                                                       (0x00000000U)
#define NVC5B7_OS_ERROR_EXECUTE_INSUFFICIENT_DATA                               (0x00000001U)
#define NVC5B7_OS_ERROR_SEMAPHORE_INSUFFICIENT_DATA                             (0x00000002U)
#define NVC5B7_OS_ERROR_INVALID_METHOD                                          (0x00000003U)
#define NVC5B7_OS_ERROR_INVALID_DMA_PAGE                                        (0x00000004U)
#define NVC5B7_OS_ERROR_UNHANDLED_INTERRUPT                                     (0x00000005U)
#define NVC5B7_OS_ERROR_EXCEPTION                                               (0x00000006U)
#define NVC5B7_OS_ERROR_INVALID_CTXSW_REQUEST                                   (0x00000007U)
#define NVC5B7_OS_ERROR_APPLICATION                                             (0x00000008U)
#define NVC5B7_OS_INTERRUPT_EXECUTE_AWAKEN                                      (0x00000100U)
#define NVC5B7_OS_INTERRUPT_BACKEND_SEMAPHORE_AWAKEN                            (0x00000200U)
#define NVC5B7_OS_INTERRUPT_CTX_ERROR_FBIF                                      (0x00000300U)
#define NVC5B7_OS_INTERRUPT_LIMIT_VIOLATION                                     (0x00000400U)
#define NVC5B7_OS_INTERRUPT_LIMIT_AND_FBIF_CTX_ERROR                            (0x00000500U)
#define NVC5B7_OS_INTERRUPT_HALT_ENGINE                                         (0x00000600U)
#define NVC5B7_OS_INTERRUPT_TRAP_NONSTALL                                       (0x00000700U)
#define NVC5B7_OS_INTERRUPT_CTX_SAVE_DONE                                       (0x00000800U)
#define NVC5B7_OS_INTERRUPT_CTX_RESTORE_DONE                                    (0x00000900U)
#define NVC5B7_ENC_ERROR_H264_APPTIMER_EXPIRED                                  (0x30000001U)
#define NVC5B7_ENC_ERROR_H264_INVALID_INPUT                                     (0x30000002U)
#define NVC5B7_ENC_ERROR_H264_HWERR_INTERRUPT                                   (0x30000003U)
#define NVC5B7_ENC_ERROR_H264_BAD_MAGIC                                         (0x30000004U)

#ifdef __cplusplus
};     /* extern "C" */
#endif
#endif // _clc5b7_h

