/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://webaudio.github.io/web-audio-api/
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

enum OverSampleType {
  "none",
  "2x",
  "4x"
};

dictionary WaveShaperOptions : AudioNodeOptions {
             sequence<float> curve;
             OverSampleType  oversample = "none";
};

[Pref="dom.webaudio.enabled",
 Exposed=Window]
interface WaveShaperNode : AudioNode {
  [Throws]
  constructor(BaseAudioContext context,
              optional WaveShaperOptions options = {});

      [Cached, Pure, Throws]
      attribute Float32Array? curve;
      attribute OverSampleType oversample;

};

// Mozilla extension
WaveShaperNode includes AudioNodePassThrough;
