.\"
.\" Copyright (c) Mark J. Kilgard, 1998.
.\"
.\" See the file "man/LICENSE" for information on usage and redistribution
.\"
.TH glutIgnoreKeyRepeat 3 "April 2025" "freeglut" "freeglut"
.SH NAME
glutIgnoreKeyRepeat - determines if auto repeat keystrokes are reported to the current window
.SH SYNTAX
.nf
.LP
void glutIgnoreKeyRepeat(int ignore);
.fi
.SH ARGUMENTS
.IP \fIignore\fP 1i
Non-zero indicates auto repeat keystrokes should not be reported by the keyboard and special callbacks; zero indicates that auto repeat keystrokes will be reported.
.SH DESCRIPTION
glutIgnoreKeyRepeat determines if auto repeat keystrokes are reported to the current window.
The ignore auto repeat state of a window can be queried with
glutDeviceGet(GLUT_DEVICE_IGNORE_KEY_REPEAT).

Ignoring auto repeated keystrokes is generally done in conjunction
with using the glutKeyboardUpFunc and glutSpecialUpFunc callbacks
to repeat key releases.  If you do not ignore auto repeated keystrokes,
your GLUT application will experience repeated release/press callbacks.
Games using the keyboard will typically want to ignore key repeat.
.SH GLUT IMPLEMENTATION NOTES FOR X11
X11 sends KeyPress events repeatedly when the window system's global auto repeat is enabled.  glutIgnoreKeyRepeat can prevent these auto repeated keystrokes from being reported as keyboard or special callbacks, but there is still some minimal overhead by the X server to continually stream KeyPress events to the GLUT application.  The glutSetKeyRepeat routine can be used to actually disable the global sending of auto repeated KeyPress events.  Note that glutSetKeyRepeat affects the global window system auto repeat state so other applications will not auto repeat if you disable auto repeat globally through glutSetKeyRepeat.
.SH SEE ALSO
glutSetKeyRepeat, glutDeviceGet, glutKeyboardFunc, glutKeyboardUpFunc, glutSpecialFunc, glutSpecialUpFunc
.SH AUTHOR
Mark J. Kilgard (mjk@nvidia.com)
