// Generated by gmmproc 2.84.0 -- DO NOT MODIFY!
#ifndef _GSKMM_ROUNDEDRECT_H
#define _GSKMM_ROUNDEDRECT_H

#include <gskmmconfig.h>


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2025 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */


#include <gdkmm/graphene_point.h>
#include <gdkmm/graphene_rect.h>
#include <gdkmm/graphene_size.h>
#include <array>
#include <utility> // std::pair
#include <gsk/gsk.h>


namespace Gsk
{
/** A rectangular region with rounded corners.
 *
 * Application code should normalize rectangles using
 * normalize(); this function will ensure that
 * the bounds of the rectangle are normalized and ensure that the corner
 * values are positive and the corners do not overlap.
 *
 * All functions taking a `%Gsk::RoundedRect` as an argument will internally
 * operate on a normalized copy; all functions returning a `%Gsk::RoundedRect`
 * will always return a normalized one.
 *
 * The algorithm used for normalizing corner sizes is described in
 * [the CSS specification](https://drafts.csswg.org/css-backgrounds-3/#border-radius).
 *
 * @newin{4,20}
 */
class GSKMM_API RoundedRect
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = RoundedRect;
  using BaseObjectType = GskRoundedRect;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

  
public:
  RoundedRect();
  RoundedRect(const GskRoundedRect* rounded_rect);
  RoundedRect(const Gdk::Graphene::Rect& bounds,
    const Gdk::Graphene::Size& top_left,
    const Gdk::Graphene::Size& top_right,
    const Gdk::Graphene::Size& bottom_right,
    const Gdk::Graphene::Size& bottom_left);
  RoundedRect(const Gdk::Graphene::Rect& bounds, float radius);

  RoundedRect(const RoundedRect& other) noexcept;
  RoundedRect& operator=(const RoundedRect& other) noexcept;

  RoundedRect(RoundedRect&& other) noexcept;
  RoundedRect& operator=(RoundedRect&& other) noexcept;

  
  /** Initializes a rounded rectangle with the given values.
   * 
   * This function will implicitly normalize the rounded rectangle
   * before returning.
   * 
   * @param bounds A `graphene_rect_t` describing the bounds.
   * @param top_left The rounding radius of the top left corner.
   * @param top_right The rounding radius of the top right corner.
   * @param bottom_right The rounding radius of the bottom right corner.
   * @param bottom_left The rounding radius of the bottom left corner.
   */
  void set(const Gdk::Graphene::Rect& bounds, const Gdk::Graphene::Size& top_left, const Gdk::Graphene::Size& top_right, const Gdk::Graphene::Size& bottom_right, const Gdk::Graphene::Size& bottom_left);
  
  /** Initializes a rounded rectangle to the given bounds
   * and sets the radius of all four corners equally.
   * 
   * @param bounds A `graphene_rect_t`.
   * @param radius The border radius.
   */
  void set(const Gdk::Graphene::Rect& bounds, float radius);

  /** Get the bounding rectangle and the corner radii.
   *
   * You can use the Gsk::Corner enum to select a corner.
   * @code
   * auto [bounds, corners] = rounded_rect.get();
   * auto top_right = corners[Gsk::Corner::TOP_RIGHT];
   * @endcode
   * @return {bounds, corners} The bounding rectangle and the corner radii.
   */
  std::pair<Gdk::Graphene::Rect, std::array<Gdk::Graphene::Size, 4>> get() const;

  
  /** Normalizes a rounded rectangle.
   * 
   * This function will ensure that the bounds of the rounded rectangle
   * are normalized and ensure that the corner values are positive
   * and the corners do not overlap.
   */
  void normalize();
  
  /** Offsets the rounded rectangle's origin by @a dx and @a dy.
   * 
   * The size and corners of the rounded rectangle are unchanged.
   * 
   * @param dx The horizontal offset.
   * @param dy The vertical offset.
   */
  void offset(float dx, float dy);
  
  /** Shrinks (or grows) a rounded rectangle by moving the 4 sides
   * according to the offsets given.
   * 
   * The corner radii will be changed in a way that tries to keep
   * the center of the corner circle intact. This emulates CSS behavior.
   * 
   * This function also works for growing rounded rectangles
   * if you pass negative values for the @a top, @a right, @a bottom or @a left.
   * 
   * @param top How far to move the top side downwards.
   * @param right How far to move the right side to the left.
   * @param bottom How far to move the bottom side upwards.
   * @param left How far to move the left side to the right.
   */
  void shrink(float top, float right, float bottom, float left);
  
  /** Checks if all corners of a rounded rectangle are right angles
   * and the rectangle covers all of its bounds.
   * 
   * This information can be used to decide if Gsk::ClipNode::new()
   * or Gsk::RoundedClipNode::new() should be called.
   * 
   * @return True if the rounded rectangle is rectilinear.
   */
  bool is_rectilinear() const;
  
  /** Checks if the given point is inside the rounded rectangle.
   * 
   * @param point The point to check.
   * @return True if the point is inside the rounded rectangle.
   */
  bool contains(const Gdk::Graphene::Point& point) const;
  
  /** Checks if the given rectangle is contained inside the rounded rectangle.
   * 
   * @param rect The rectangle to check.
   * @return True if the @a rect is fully contained inside the rounded rectangle.
   */
  bool contains(const Gdk::Graphene::Rect& rect) const;
  
  /** Checks if part a rectangle is contained
   * inside the rounded rectangle.
   * 
   * @param rect The rectangle to check.
   * @return True if the @a rect intersects with the rounded rectangle.
   */
  bool intersects(const Gdk::Graphene::Rect& rect) const;

  /// Provides access to the underlying C GObject.
  GskRoundedRect*       gobj()       { return &gobject_; }
  /// Provides access to the underlying C GObject.
  const GskRoundedRect* gobj() const { return &gobject_; }

protected:
  GskRoundedRect gobject_;


};

} // namespace Gsk


#endif /* _GSKMM_ROUNDEDRECT_H */

