/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2000-2001 by Andreas Zehender
    email                : zehender@kde.org
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/


#include "pmmaterial.h"
#include "pmoutputdevice.h"
#include "pmxmlhelper.h"
#include "pmmemento.h"
#include "pmmaterialedit.h"

#include <kdebug.h>
#include "pmglobals.h"
#include <klocale.h>

bool PMMaterial::s_linkPossibilitiesCreated = false;
QValueList<PMDeclare::PMDeclareType> PMMaterial::s_linkPossibilities;

PMMaterial::PMMaterial( )
      : Base( )
{
}

PMMaterial::~PMMaterial( )
{
}

bool PMMaterial::isA( PMObjectType t ) const
{
   if( t == PMTMaterial )
      return true;
   return Base::isA( t );
}

QString PMMaterial::description( ) const
{
   return i18n( "material" );
}


void PMMaterial::serialize( PMOutputDevice& dev ) const
{
   dev.objectBegin( "material" );
   Base::serialize( dev );
   dev.objectEnd( );
}


bool PMMaterial::canInsert( PMObjectType t, const PMObject* ,
                            const PMObjectList* ) const
{
   switch( t )
   {
      case PMTTexture:
      case PMTInterior:
      case PMTComment:
      case PMTRaw:
      case PMTTranslate:
      case PMTScale:
      case PMTRotate:
      case PMTMatrix:
         return true;
      default:
         break;
   }
   return false;
}

QValueList<PMDeclare::PMDeclareType> PMMaterial::linkPossibilities( ) const
{
   if( !s_linkPossibilitiesCreated )
   {
      s_linkPossibilities.append( PMDeclare::MaterialDeclare );
      s_linkPossibilitiesCreated = true;
   }
   return s_linkPossibilities;
}

PMDialogEditBase* PMMaterial::editWidget( QWidget* parent ) const
{
   return new PMMaterialEdit( parent );
}

