/***************************************************************************
                            KURLLabel.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KURLLABEL_H
#define KURLLABEL_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QLabel.h>

/**

 A label class that supports displaying an active hyperlink.

 KURLLabel is a drop-in replacement for QLabel that handles text
 in a fashion similar to how an HTML widget handles hyperlinks.  The
 text can be underlined (or not) and set to different colors.  It
 can also "glow" (cycle colors) when the mouse passes over it.

 KURLLabel also provides signals for several events, including
 the mouse leaving and entering the text area and all forms of
 mouse clicking.

 A typical usage would be something like so:

 <PRE>
     KURLLabel *address = new KURLLabel(this);
     -[address setText]("My homepage");
     -[address setURL]("http://www.home.com/~me");
     connect(address, SIGNAL(leftClickedURL(const QString&)),
                      SLOT(processMyURL(const QString&)));
 </PRE>

 In this example, the text "My homepage" would be displayed
 as blue, underlined text.  When the mouse passed over it, 
 it would "glow" red.  When the user clicks on the text, the
 signal @ref -leftClickedURL would be emitted with "http://www.home.com/~me"
 as its argument.

 
 @author Peter Putzer <putzer@kde.org> (Rewrite)

 @version $Id: KURLLabel.h,v 1.3 2002/03/15 02:12:24 rdale Exp $

 @short A drop-in replacement for QLabel that displays hyperlinks.

*/
@interface KURLLabel : QLabel 

/** 
 Default constructor.

 Use @ref  #--setURL and @ref  #--setText or @ref -[QListView setPixmap]
 to set the resp. properties.
   
*/
- initWithWidget: (QWidget *)parent name: (NSString *)name;
- init;

/** 
 Convenience constructor.

 @p parent and @p name are passed to @ref QLabel.
   
*/
- initWithText: (NSString *)url text: (NSString *)text parent: (QWidget *)parent name: (NSString *)name;
- initWithText: (NSString *)url ;

/** 
 Destructs the label.
   
*/
- (void) dealloc;

/** 
 Returns the URL.
   
*/
- (NSString *) url;

/** 
 Returns the current tooltip text.
   
*/
- (NSString *) tipText;

/** 

*/
- (BOOL) useTips;

/** 

*/
- (BOOL) useCursor;

/** 
 When this is on, the text will switch to the selected 
 color whenever the mouse passes over it.
   
*/
- (BOOL) isGlowEnabled;

/** 
 This feature is very similar to the "glow" feature in that the color of the
 label switches to the selected color when the cursor passes
 over it. In addition, underlining is turned on for as
 long as the mouse is overhead. Note that if "glow" and
 underlining are both already turned on, this feature
 will have no visible effect.
   
*/
- (BOOL) isFloatEnabled;

/** 

*/
- (QPixmap*) altPixmap;

/** 
 Turns on or off the underlining.

  When this is on, the
 text will be underlined.  By default, it is @p true.
   
*/
- setUnderline: (BOOL)on;
- setUnderline;

/** 
 Sets the URL for this label to @p url.

*/
- setURL: (NSString *)url;

/** 
 Overridden for internal reasons; the API remains unaffected.
   
*/
- setFont: (QFont *)arg1;

/** 
 Turns on or off the tool tip feature.

 When this is on, the URL will be displayed as a
 tooltip whenever the mouse passes passes over it.
 By default, it is @p false.
   
*/
- setUseTips: (BOOL)on;
- setUseTips;

/** 
 Specifies what text to display when tooltips are turned on.

 If this is not used, the tip will default to the URL.

*/
- setTipText: (NSString *)tip;

/** 
 Sets the highlight color.

 This is the default foreground
 color (non-selected).  By default, it is @p blue.
   
*/
- setHighlightedColor: (QColor *)highcolor;

/** 
 This is an overloaded version for convenience.

*/
- setHighlightedColorWithName: (NSString *)highcolor;

/** 
 Sets the selected color.

 This is the color the text will change
 to when either a mouse passes over it and "glow" mode is on or
 when it is selected (clicked).  By default, it is @p red.
   
*/
- setSelectedColor: (QColor *)selcolor;

/** 
 This is an overloaded version for convenience.

*/
- setSelectedColorWithName: (NSString *)selcolor;

/** 
 Turns the custom cursor feature on or off.

 When this is on, the cursor will change to a custom cursor
 (default is a "pointing hand") whenever the cursor passes
 over the label. By default, it is on.

*/
- setUseCursor: (BOOL)on cursor: (QCursor *)cursor;
- setUseCursor: (BOOL)on ;

/** 
 Turns on or off the "glow" feature. 

 When this is on, the text will switch to the
 selected color whenever the mouse
 passes over it. By default, it is @p true.
   
*/
- setGlow: (BOOL)glow;
- setGlow;

/** 
 Turns on or off the "float" feature.

 This feature is very similar to the "glow" feature in
 that the color of the label switches to the selected 
 color when the cursor passes over it. In addition,
 underlining is turned on for as long as the mouse is overhead.
 Note that if "glow" and underlining are both already turned
 on, this feature will have no visible effect.
 By default, it is @p false.
   
*/
- setFloat: (BOOL)do_float;
- setFloat;

/** 
 Sets the "alt" pixmap. 

 This pixmap will be displayed when the
 cursor passes over the label.  The effect is similar to the
 trick done with 'onMouseOver' in javascript.

*/
- setAltPixmap: (QPixmap *)altPix;
@end

/** Override these methods in subclasses of KURLLabel to customise event handling behaviour */
@protocol KURLLabelEventHandling
- keyPressEvent:(QKeyEvent*) arg1;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;

/** 
 Overridden for internal reasons; the API remains unaffected.
   
*/
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;

/** 
 Overridden for internal reasons; the API remains unaffected.
   
*/
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;

/** 
 Overridden for internal reasons; the API remains unaffected.
   
*/
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
