/***************************************************************************
                            KIntSpinBox.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KINTSPINBOX_H
#define KINTSPINBOX_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QSpinBox.h>

/**

  An integer inputline with scrollbar and slider.

  The class provides an easy interface to use other
  numeric systems then the decimal.

 @short A spin box widget for non-decimal numbers.
 
*/
@interface KIntSpinBox : QSpinBox 

/** 
  Constructor.

  Constructs a widget with an integer inputline with a little scrollbar
  and a slider, with minimal value 0, maximal value 99, step 1, base 10
  and initial value 0.
     
*/
- initWithWidget: (QWidget *)parent name: (NSString *)name;
- init;

/** 
  Constructor.

  Constructs a widget with an integer inputline with a little scrollbar
  and a slider.

*/
- initWithInt: (int)lower upper: (int)upper step: (int)step value: (int)value base: (int)base parent: (QWidget *)parent name: (NSString *)name;
- initWithInt: (int)lower upper: (int)upper step: (int)step value: (int)value ;

/** 
  Destructor.
     
*/
- (void) dealloc;

/** 
 Sets the base in which the numbers in the spin box are represented.
     
*/
- setBase: (int)base;

/** 

*/
- (int) base;

/** 
 sets focus and optionally marks all text

     
*/
- setEditFocus: (BOOL)mark;

/** 
  Overloaded the method in QSpinBox
  to make use of the base given in the constructor.
     
*/
- (NSString *) mapValueToText: (int)arg1;

/** 
  Overloaded the method in QSpinBox
  to make use of the base given in the constructor.
     
*/
- (int) mapTextToValue: (int*)arg1;
@end

/** Override these methods in subclasses of KIntSpinBox to customise event handling behaviour */
@protocol KIntSpinBoxEventHandling
- keyPressEvent:(QKeyEvent*) arg1;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- resizeEvent:(QResizeEvent*) ev;
@end


#endif
