/***************************************************************************
                            DockMainWindow.java -  description
                             -------------------
    begin                : Sun Nov 17 05:00:18 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 17 05:00:18 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 A KPart-aware main window with ability for docking widgets, whose user interface is described in XML.

 Inherit your main dock-window from this class
 and don't forget to call {@link #setXMLFile} in the inherited constructor.

 It implements all internal interfaces in the case of a {@link KDockMainWindow} as host:
 the builder and servant interface (for menu merging).
 
 See {@link DockMainWindowSignals} for signals emitted by DockMainWindow.

 

 @short *
 A KPart-aware main window with ability for docking widgets, whose user interface is described in XML.
*/
public class DockMainWindow extends KDockMainWindow implements  PartBaseInterface {
	protected DockMainWindow(Class dummy){super((Class) null);}

	private native void newDockMainWindow( QWidget parent, String name, int f);

/** 
 Constructor, same signature as {@link KDockMainWindow}.
   
*/
	public DockMainWindow( QWidget parent, String name, int f) {
		super((Class) null);
		newDockMainWindow( parent, name, f);
	}
	private native void newDockMainWindow();
	public DockMainWindow() {
		super((Class) null);
		newDockMainWindow();
	}

/** 
 Destructor.
   
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();
	protected native void createShellGUI( boolean create);
	protected native void createShellGUI();

/** 
 Create the GUI (by merging the host's and the active part's)

 Called on startup and whenever the active part changes
 For this you need to connect this slot to the
 {@link KPartManager#activePartChanged} signal

*/
	protected native void createGUI( Part part);

/** 
 Called when the active part wants to change the statusbar message
 Reimplement if your dock-mainwindow has a complex statusbar
 (with several items)
   
*/
	protected native void slotSetStatusBarText( String arg1);

/**
  Internal method. Called by {@link KParts#Part} to specify the parent object for plugin objects.


*/
	public native void setPartObject( QObject object);
	public native QObject partObject();

/**
 Set the instance ({@link KInstance}) for this part.

 Call this first in the inherited class constructor,
 because it loads the i18n catalogues.

*/
	public native void setInstance( KInstanceInterface instance);

/**
 Set the instance ({@link KInstance}) for this part.

 Call this first in the inherited class constructor,
 because it loads the i18n catalogues.

*/
	public native void setInstance( KInstanceInterface instance, boolean loadPlugins);
}
