/***************************************************************************
                            kde_KRun.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KRUN
#define KDE_KRUN

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 To open files with their associated applications in KDE, use KRun.

 It can execute any desktop entry, as well as any file, using
 the default application or another application "bound" to the file type.

 In that example, the mimetype of the file is not known by the application,
 so a KRun instance must be created. It will determine the mimetype by itself.
 If the mimetype is known, or if you even know the service (application) to
 use for this file, use one of the static methods.

 @short Opens files with their associated applications in KDE.
*/

/** *
 Create a KRun object to run the preferred application for a file/URL.
 KRun will first determine the type of the file, and will then
 run the associated application.

*/
kde_KRun * kde_new_KRun(kde_KURL* url, long mode, int isLocalFile, int showProgressInfo);

/** *
 Destructor. Don't call it yourself, since a KRun object auto-deletes
 itself.
   
*/
void kde_del_KRun( kde_KRun* p );

/** *
 Abort this KRun. This kills any jobs launched by it,
 and leads to deletion if auto-deletion is on.
 This is much safer than deleting the KRun (in case it's
 currently showing an error dialog box, for instance)
   
*/
void kde_KRun_abort(kde_KRun* instPointer);
int kde_KRun_hasError(kde_KRun* instPointer);
int kde_KRun_hasFinished(kde_KRun* instPointer);

/** *
 By default auto deletion is on.
   
*/
int kde_KRun_autoDelete(kde_KRun* instPointer);
void kde_KRun_setAutoDelete(kde_KRun* instPointer,int b);

/** *
 Set the preferred service for opening this URL, after
 its mimetype will have been found by KRun. IMPORTANT: the service is
 only used if its configuration says it can handle this mimetype.
 This is used for instance for the X-KDE-LastOpenedWith key, for
 the recent documents list.

*/
void kde_KRun_setPreferredService(kde_KRun* instPointer,qt_QString * desktopEntryName);

/** *
 Open a list of URLs with a certain service.

*/
long kde_KRun_run( kde_KService* _service, kde_KURLList* _urls);

/** *
 Open a list of URLs with.

*/
long kde_KRun_run1( qt_QString * _exec, kde_KURLList* _urls, qt_QString * _name, qt_QString * _icon, qt_QString * _obsolete1, qt_QString * _obsolete2);

/** *
 Open the given URL.

 This function is used after the mime type
 is found out. It will search for all services which can handle
 the mime type and call @ref run() afterwards.
   
*/
long kde_KRun_runURL( kde_KURL* _url, qt_QString * _mimetype);

/** *
 Run the given shell command and notifies kicker of the starting
 of the application. If the program to be called doesn't exist,
 an error box will be displayed.

 @p _cmd must be a shell command. You must not append "&"
 to it, since the function will do that for you.

 Use only when you know the full command line. Otherwise use the other
 static methods, or KRun's constructor.
   
*/
long kde_KRun_runCommand( qt_QString * cmd);

/** *
 Same as the other runCommand, but it also takes the name of the
 binary, to display an error message in case it couldn't find it.

*/
long kde_KRun_runCommand1( qt_QString * cmd, qt_QString * execName, qt_QString * icon);

/** *
 Display the Open-With dialog for those URLs, and run the chosen application.

*/
int kde_KRun_displayOpenWithDialog( kde_KURLList* lst);

/** *
 Quotes a string for the shell
   
*/
void kde_KRun_shellQuote( qt_QString * _str);

/** *
 Processes a Exec= line as found in .desktop files.

*/
qt_QStringList* kde_KRun_processDesktopExec( kde_KService* _service, kde_KURLList* _urls, int has_shell);

/** *
 Given a full command line (e.g. the Exec= line from a .desktop file),
 extract the name of the binary being run.

*/
qt_QString * kde_KRun_binaryName( qt_QString * execLine, int removePath);
void kde_KRun_init(kde_KRun* instPointer);
void kde_KRun_scanFile(kde_KRun* instPointer);

/** *
 Called if the mimetype has been detected. The function checks
 whether the document and appends the gzip protocol to the
 URL. Otherwise @ref #runURL is called to finish the job.
   
*/
void kde_KRun_foundMimeType(kde_KRun* instPointer,qt_QString * _type);
void kde_KRun_killJob(kde_KRun* instPointer);

/** *
 USed to indicate that the next action is to initialize.
 This action is invoked from @ref #slotTimeout
   
*/
void kde_KRun_virtual_hook(kde_KRun* instPointer,int identifier, void* data);
void kde_KRun_slotTimeout(kde_KRun* instPointer);
void kde_KRun_slotScanFinished(kde_KRun* instPointer,kde_Job* arg1);
void kde_KRun_slotScanMimeType(kde_KRun* instPointer,kde_Job* arg1, qt_QString * type);
void kde_KRun_slotStatResult(kde_KRun* instPointer,kde_Job* arg1);

#endif
