/***************************************************************************
                            kde_KFontChooser.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KFONTCHOOSER
#define KDE_KFONTCHOOSER

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 While KFontChooser as an ordinary widget can be embedded in
 custom dialogs and therefore is very flexible, in most cases
 it is preferable to use the convenience functions in
 @ref KFontDialog.

 @author Preston Brown <pbrown@kde.org>, Bernd Wuebben <wuebben@kde.org>

 @version $Id: kde_KFontChooser.h,v 1.5 2002/11/25 12:24:34 rdale Exp $
 
 @short A font selection widget.

*/
#define KFONTCHOOSER_FamilyList	0x01
#define KFONTCHOOSER_StyleList	0x02
#define KFONTCHOOSER_SizeList	0x04
#define KFONTCHOOSER_FontDiffFamily	0x01
#define KFONTCHOOSER_FontDiffStyle	0x02
#define KFONTCHOOSER_FontDiffSize	0x04
#define KFONTCHOOSER_FixedWidthFonts	0x01
#define KFONTCHOOSER_ScalableFonts	0x02
#define KFONTCHOOSER_SmoothScalableFonts	0x04

/** *
 Constructs a font picker widget.
 It normally comes up with all font families present on the system; the
 getFont method below does allow some more fine-tuning of the selection of fonts
 that will be displayed in the dialog.
 <p>Consider the following code snippet;<pre>

    QStringList list;
    KFontChooser::getFontList(list,SmoothScalableFonts);
    KFontChooser chooseFont = new KFontChooser(0, "FontList", false, list);
 </pre>
 <p>The above creates a font chooser dialog with only SmoothScaleble fonts.

*/
kde_KFontChooser * kde_new_KFontChooser(qt_QWidget * parent, char* name, int onlyFixed, qt_QStringList* fontList, int makeFrame, int visibleListSize, int diff, int* sizeIsRelativeState);

/** *
 Destructs the font chooser.
   
*/
void kde_del_KFontChooser( kde_KFontChooser* p );

/** *
 Enables or disable a font column in the chooser.

 Use this
 function if your application does not need or supports all font
 properties.

*/
void kde_KFontChooser_enableColumn(kde_KFontChooser* instPointer,int column, int state);

/** *
 Sets the currently selected font in the chooser.

*/
void kde_KFontChooser_setFont(kde_KFontChooser* instPointer,qt_QFont * font, int onlyFixed);

/** *

*/
int kde_KFontChooser_fontDiffFlags(kde_KFontChooser* instPointer);

/** *

*/
qt_QFont * kde_KFontChooser_font(kde_KFontChooser* instPointer);

/** *
 Sets the color to use in the preview.
   
*/
void kde_KFontChooser_setColor(kde_KFontChooser* instPointer,qt_QColor * col);

/** *

*/
qt_QColor * kde_KFontChooser_color(kde_KFontChooser* instPointer);

/** *
 Sets the background color to use in the preview.
   
*/
void kde_KFontChooser_setBackgroundColor(kde_KFontChooser* instPointer,qt_QColor * col);

/** *

*/
qt_QColor * kde_KFontChooser_backgroundColor(kde_KFontChooser* instPointer);

/** *
 Sets the state of the checkbox indicating whether the font size
 is to be interpreted as relative size.
 NOTE: If parameter sizeIsRelative was not set in the constructor
       of the widget this setting will be ignored.
   
*/
//void kde_KFontChooser_setSizeIsRelative(kde_KFontChooser* instPointer,QButton::ToggleState relative);

/** *

*/
//QButton::ToggleState kde_KFontChooser_sizeIsRelative(kde_KFontChooser* instPointer);

/** *

*/
qt_QString * kde_KFontChooser_sampleText(kde_KFontChooser* instPointer);

/** *
 Sets the sample text.

 Normally you should not change this
 text, but it can be better to do this if the default text is
 too large for the edit area when using the default font of your
 application.

*/
void kde_KFontChooser_setSampleText(kde_KFontChooser* instPointer,qt_QString * text);

/** *
 Reimplemented for internal reasons.
   
*/
qt_QSize * kde_KFontChooser_sizeHint(kde_KFontChooser* instPointer);

/** *
 Converts a @ref QFont into the corresponding X Logical Font
 Description (XLFD).

*/
qt_QString * kde_KFontChooser_getXLFD( qt_QFont * theFont);

/** *
 Creates a list of font strings.

*/
void kde_KFontChooser_getFontList( qt_QStringList* list, unsigned int fontListCriteria);
void kde_KFontChooser_virtual_hook(kde_KFontChooser* instPointer,int identifier, void* data);

#endif
